/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CreaturesYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class GoblinLyreEffect
extends OneShotEffect {
    GoblinLyreEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, {this} deals damage to target opponent or planeswalker equal to the number of creatures you control. If you lose the flip, {this} deals damage to you equal to the number of creatures that opponent or that planeswalker's controller controls";
    }

    private GoblinLyreEffect(GoblinLyreEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinLyreEffect copy() {
        return new GoblinLyreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayerOrPlaneswalkerController(this.getTargetPointer().getFirst(game, source));
        if (controller != null) {
            if (controller.flipCoin(source, game, true)) {
                int damage = CreaturesYouControlCount.PLURAL.calculate(game, source, (Effect)this);
                if (opponent != null) {
                    return game.damagePlayerOrPermanent(source.getFirstTarget(), damage, source.getSourceId(), source, game, false, true) > 0;
                }
            } else {
                int damage = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterCreaturePermanent(), opponent.getId(), game).size();
                return controller.damage(damage, source.getSourceId(), source, game) > 0;
            }
        }
        return false;
    }
}

