/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GoblinResearcherCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class GoblinResearcherEffect
extends OneShotEffect {
    GoblinResearcherEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. During any turn you attacked with {this}, you may play that card";
    }

    private GoblinResearcherEffect(GoblinResearcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinResearcherEffect copy() {
        return new GoblinResearcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)false, (UUID)source.getControllerId(), (Condition)GoblinResearcherCondition.instance);
        return true;
    }
}

