/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class GoblinResearcherWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> map = new HashMap<MageObjectReference, Set<UUID>>();

    GoblinResearcherWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED) {
            return;
        }
        this.map.computeIfAbsent(new MageObjectReference(event.getSourceId(), game), x -> new HashSet()).add(event.getPlayerId());
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        return ((GoblinResearcherWatcher)game.getState().getWatcher(GoblinResearcherWatcher.class)).map.getOrDefault(new MageObjectReference(source, 0), Collections.emptySet()).contains(source.getControllerId());
    }
}

