/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GodEternalRhonasEffect
extends OneShotEffect {
    GodEternalRhonasEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power of each other creature you control until end of turn. Those creatures gain vigilance until end of turn.";
    }

    private GodEternalRhonasEffect(GodEternalRhonasEffect effect) {
        super((OneShotEffect)effect);
    }

    public GodEternalRhonasEffect copy() {
        return new GodEternalRhonasEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent godEternalRhonas = game.getPermanent(source.getSourceId());
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, source.getControllerId(), game)) {
            if (permanent == null || godEternalRhonas != null && permanent == godEternalRhonas) continue;
            BoostTargetEffect effect = new BoostTargetEffect(permanent.getPower().getValue(), 0, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            GainAbilityTargetEffect effect2 = new GainAbilityTargetEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn);
            effect2.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect2, source);
        }
        return true;
    }
}

