/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class GollumSchemingGuideEffect
extends OneShotEffect {
    GollumSchemingGuideEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top two cards of your library, put them back in any order, then choose land or nonland. An opponent guesses whether the top card of your library is the chosen kind. Reveal that card. If they guessed right, remove {this} from combat. Otherwise, you draw a card and {this} can't be blocked this turn";
    }

    private GollumSchemingGuideEffect(GollumSchemingGuideEffect effect) {
        super((OneShotEffect)effect);
    }

    public GollumSchemingGuideEffect copy() {
        return new GollumSchemingGuideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        player.lookAtCards(source, null, (Cards)cards, game);
        PutCards.TOP_ANY.moveCards(player, (Cards)cards, source, game);
        boolean guessLand = player.chooseUse(Outcome.Neutral, "Choose land or nonland (opponent must then guess)", "", "land", "nonland", source, game);
        TargetOpponent targetOpponent = new TargetOpponent(true);
        if (!player.choose(Outcome.Neutral, (Target)targetOpponent, source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        String textGuess = guessLand ? "land" : "nonland";
        FilterLandCard filter = guessLand ? StaticFilters.FILTER_CARD_LAND : StaticFilters.FILTER_CARD_NON_LAND;
        boolean guessOpp = opponent.chooseUse(Outcome.Neutral, "Is the top card of " + player.getLogName() + "'s library a " + textGuess + " card?", source, game);
        Card card = player.getLibrary().getFromTop(game);
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card != null && filter.match(card, player.getId(), source, game) == guessOpp) {
            game.informPlayers(opponent.getLogName() + " guessed right.");
            Permanent gollum = source.getSourcePermanentIfItStillExists(game);
            if (gollum != null) {
                gollum.removeFromCombat(game);
            }
        } else {
            game.informPlayers(opponent.getLogName() + " guessed wrong.");
            player.drawCards(1, source, game);
            Permanent gollum = source.getSourcePermanentIfItStillExists(game);
            if (gollum != null) {
                game.addEffect((ContinuousEffect)new CantBeBlockedSourceEffect(Duration.EndOfTurn), source);
            }
        }
        return true;
    }
}

