/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.token.SalamanderWarriorToken;
import mage.util.CardUtil;

class GorMuldrakAmphinologistEffect
extends OneShotEffect {
    GorMuldrakAmphinologistEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player who controls the fewest creatures creates a 4/3 blue Salamander Warrior creature token";
    }

    private GorMuldrakAmphinologistEffect(GorMuldrakAmphinologistEffect effect) {
        super((OneShotEffect)effect);
    }

    public GorMuldrakAmphinologistEffect copy() {
        return new GorMuldrakAmphinologistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap creatureMap = new HashMap();
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().forEach(uuid -> creatureMap.put(uuid, 0));
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game).stream().filter(Objects::nonNull).map(Controllable::getControllerId).forEach(uuid -> creatureMap.compute(uuid, CardUtil::setOrIncrementValue));
        int minValue = creatureMap.values().stream().mapToInt(x -> x).min().orElse(0);
        minValue = Math.max(minValue, 0);
        SalamanderWarriorToken token = new SalamanderWarriorToken();
        for (Map.Entry entry : creatureMap.entrySet()) {
            if ((Integer)entry.getValue() > minValue) continue;
            token.putOntoBattlefield(1, game, source, (UUID)entry.getKey());
        }
        return true;
    }
}

