/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class GorbagOfMinasMorgulEffect
extends OneShotEffect {
    private static ReflexiveTriggeredAbility makeAbility() {
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1), false);
        ability.addMode(new Mode((Effect)new CreateTokenEffect((Token)new TreasureToken())));
        return ability;
    }

    GorbagOfMinasMorgulEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice it. When you do, " + GorbagOfMinasMorgulEffect.makeAbility().getRule();
    }

    private GorbagOfMinasMorgulEffect(GorbagOfMinasMorgulEffect effect) {
        super((OneShotEffect)effect);
    }

    public GorbagOfMinasMorgulEffect copy() {
        return new GorbagOfMinasMorgulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return player != null && permanent != null && player.chooseUse(this.outcome, "Sacrifice " + permanent.getIdName() + '?', source, game) && permanent.sacrifice(source, game) && game.fireReflexiveTriggeredAbility(GorbagOfMinasMorgulEffect.makeAbility(), source) != null;
    }
}

