/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GorgingVultureEffect
extends OneShotEffect {
    GorgingVultureEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill four cards. You gain 1 life for each creature card milled this way.";
    }

    private GorgingVultureEffect(GorgingVultureEffect effect) {
        super((OneShotEffect)effect);
    }

    public GorgingVultureEffect copy() {
        return new GorgingVultureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int lifeToGain = player.millCards(4, source, game).getCards(game).stream().filter(card1 -> card1.isCreature(game)).mapToInt(card -> game.getState().getZone(card.getId()) == Zone.GRAVEYARD ? 1 : 0).sum();
        if (lifeToGain > 0) {
            game.processAction();
            player.gainLife(lifeToGain, game, source);
        }
        return true;
    }
}

