/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class GrabTheReinsEffect
extends OneShotEffect {
    GrabTheReinsEffect() {
        super(Outcome.Damage);
        this.staticText = "sacrifice a creature. {this} deals damage equal to that creature's power to any target";
    }

    private GrabTheReinsEffect(GrabTheReinsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE);
        UUID controllerId = source.getControllerId();
        if (!target.canChoose(controllerId, source, game)) {
            return false;
        }
        Player player = game.getPlayer(controllerId);
        if (player != null) {
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent creatureToSacrifice = game.getPermanent((UUID)target.getTargets().get(0));
            int amount = creatureToSacrifice.getPower().getValue();
            if (!creatureToSacrifice.sacrifice(source, game)) {
                return false;
            }
            if (amount > 0) {
                Permanent permanent = game.getPermanent(source.getFirstTarget());
                if (permanent != null) {
                    permanent.damage(amount, source.getSourceId(), source, game, false, true);
                    return true;
                }
                player = game.getPlayer(source.getFirstTarget());
                if (player != null) {
                    player.damage(amount, source.getSourceId(), source, game);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public GrabTheReinsEffect copy() {
        return new GrabTheReinsEffect(this);
    }
}

