/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TargetsDamageTargetsEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.other.AnotherTargetPredicate;
import mage.filter.predicate.permanent.EnchantedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GracefulTakedown
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("enchanted creatures you control");
    private static final FilterControlledCreaturePermanent otherCreatureFilter = new FilterControlledCreaturePermanent("other target creature you control");

    public GracefulTakedown(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{G}");
        this.getSpellAbility().addEffect((Effect)new TargetsDamageTargetsEffect(true));
        this.getSpellAbility().addTarget(new TargetPermanent(0, Integer.MAX_VALUE, filter).setTargetTag(1).withChooseHint("enchanted"));
        this.getSpellAbility().addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)otherCreatureFilter).setTargetTag(2));
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL).setTargetTag(3));
    }

    private GracefulTakedown(GracefulTakedown card) {
        super((CardImpl)card);
    }

    public GracefulTakedown copy() {
        return new GracefulTakedown(this);
    }

    static {
        filter.add((Predicate)EnchantedPredicate.instance);
        otherCreatureFilter.add((ObjectSourcePlayerPredicate)new AnotherTargetPredicate(2));
    }
}

