/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GrahaTiaScionRebornValue;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.HeroToken;

class GrahaTiaScionRebornEffect
extends OneShotEffect {
    GrahaTiaScionRebornEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 colorless Hero creature token and put X +1/+1 counters on it";
    }

    private GrahaTiaScionRebornEffect(GrahaTiaScionRebornEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrahaTiaScionRebornEffect copy() {
        return new GrahaTiaScionRebornEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HeroToken token = new HeroToken();
        token.putOntoBattlefield(1, game, source);
        int count = GrahaTiaScionRebornValue.instance.calculate(game, source, (Effect)this);
        if (count < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Optional.ofNullable(tokenId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(count), source, game));
        }
        return true;
    }
}

