/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GrappleWithThePastEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature or land card from your graveyard");

    public GrappleWithThePastEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = ", then you may return a creature or land card from your graveyard to your hand";
    }

    private GrappleWithThePastEffect(GrappleWithThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrappleWithThePastEffect copy() {
        return new GrappleWithThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        if (target.canChoose(source.getControllerId(), source, game) && controller.chooseUse(this.outcome, "Return a creature or land card from your graveyard to hand?", source, game) && controller.choose(Outcome.ReturnToHand, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
    }
}

