/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GratuitousViolenceReplacementEffect
extends ReplacementEffectImpl {
    GratuitousViolenceReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a creature you control would deal damage to a permanent or player, it deals double that damage instead";
    }

    private GratuitousViolenceReplacementEffect(GratuitousViolenceReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GratuitousViolenceReplacementEffect copy() {
        return new GratuitousViolenceReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

