/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldWithCounterTargetEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GraveEndeavorEffect
extends OneShotEffect {
    GraveEndeavorEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll two d10 and choose one result. Return a creature card from your graveyard to the battlefield with a number of +1/+1 counters on it equal to that result. Then each opponent loses X life and you gain X life, where X is the other result";
    }

    private GraveEndeavorEffect(GraveEndeavorEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveEndeavorEffect copy() {
        return new GraveEndeavorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int second;
        int first;
        int secondResult;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List results = player.rollDice(this.outcome, source, game, 10, 2, 0);
        int firstResult = (Integer)results.get(0);
        if (firstResult != (secondResult = ((Integer)results.get(1)).intValue()) && player.chooseUse(this.outcome, "Choose a number of +1/+1 counters to put on the creature you return", "The other number will be the amount of life your opponents lose and you gain", "" + firstResult, "" + secondResult, source, game)) {
            first = firstResult;
            second = secondResult;
        } else {
            first = secondResult;
            second = firstResult;
        }
        if (player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) > 0) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            if (target.getFirstTarget() != null) {
                new ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(new Counter[]{CounterType.P1P1.createInstance(first)}).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game)).apply(game, source);
            }
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            opponent.loseLife(second, game, source, false);
        }
        player.gainLife(second, game, source);
        return true;
    }
}

