/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class GravePactEffect
extends OneShotEffect {
    GravePactEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each other player sacrifices a creature of their choice";
    }

    private GravePactEffect(GravePactEffect effect) {
        super((OneShotEffect)effect);
    }

    public GravePactEffect copy() {
        return new GravePactEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList perms = new ArrayList();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetSacrifice target;
                Player player = game.getPlayer(playerId);
                if (player == null || playerId.equals(source.getControllerId()) || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE)).canChoose(player.getId(), source, game)) continue;
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
                perms.addAll(target.getTargets());
            }
            for (UUID permID : perms) {
                Permanent permanent = game.getPermanent(permID);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

