/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GravePerilEffect
extends OneShotEffect {
    GravePerilEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "sacrifice {this}. If you do, destroy that creature";
    }

    private GravePerilEffect(GravePerilEffect effect) {
        super((OneShotEffect)effect);
    }

    public GravePerilEffect copy() {
        return new GravePerilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null && permanent.sacrifice(source, game)) {
            DestroyTargetEffect effect = new DestroyTargetEffect();
            effect.setTargetPointer(this.getTargetPointer().copy());
            return effect.apply(game, source);
        }
        return false;
    }
}

