/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GraveyardShovelEffect
extends OneShotEffect {
    GraveyardShovelEffect() {
        super(Outcome.Exile);
        this.staticText = "Target player exiles a card from their graveyard. If it's a creature card, you gain 2 life";
    }

    private GraveyardShovelEffect(GraveyardShovelEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveyardShovelEffect copy() {
        return new GraveyardShovelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (targetPlayer == null || controller == null || targetPlayer.getGraveyard().isEmpty()) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard();
        target.withNotTarget(true);
        targetPlayer.chooseTarget(Outcome.Exile, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        targetPlayer.moveCards(card, Zone.EXILED, source, game);
        if (card.isCreature(game)) {
            controller.gainLife(2, game, source);
        }
        return true;
    }
}

