/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class GraveyardTrespasserEffect
extends OneShotEffect {
    GraveyardTrespasserEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target card from a graveyard. If a creature card was exiled this way, each opponent loses 1 life and you gain 1 life";
    }

    private GraveyardTrespasserEffect(GraveyardTrespasserEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveyardTrespasserEffect copy() {
        return new GraveyardTrespasserEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        int amount = cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        if (amount < 1) {
            return true;
        }
        game.processAction();
        player.gainLife(amount, game, source);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            opponent.loseLife(amount, game, source, false);
        }
        return true;
    }
}

