/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GravityWellEffect
extends ContinuousEffectImpl {
    GravityWellEffect() {
        super(Duration.EndOfTurn, Outcome.LoseAbility);
        this.staticText = "it loses flying until end of turn";
    }

    private GravityWellEffect(GravityWellEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GravityWellEffect copy() {
        return new GravityWellEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.removeAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

