/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GreatOakGuardianUntapEffect
extends OneShotEffect {
    GreatOakGuardianUntapEffect() {
        super(Outcome.Benefit);
        this.staticText = "untap them";
    }

    private GreatOakGuardianUntapEffect(GreatOakGuardianUntapEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreatOakGuardianUntapEffect copy() {
        return new GreatOakGuardianUntapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getControllerId());
        if (targetPlayer != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game)) {
                permanent.untap(game);
            }
            return true;
        }
        return false;
    }
}

