/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GriffinCanyonEffect
extends OneShotEffect {
    GriffinCanyonEffect() {
        super(Outcome.Benefit);
        this.staticText = "Untap target Griffin. If it's a creature, it gets +1/+1 until end of turn";
    }

    private GriffinCanyonEffect(GriffinCanyonEffect effect) {
        super((OneShotEffect)effect);
    }

    public GriffinCanyonEffect copy() {
        return new GriffinCanyonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null) {
            targetCreature.untap(game);
            if (StaticFilters.FILTER_PERMANENT_A_CREATURE.match((Object)targetCreature, game)) {
                game.addEffect((ContinuousEffect)new BoostTargetEffect(1, 1, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

