/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class GrimReminderWatcher
extends Watcher {
    private final Map<String, Set<UUID>> playersCastSpell = new HashMap<String, Set<UUID>>();

    public GrimReminderWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            MageObject spell = game.getObject(event.getTargetId());
            UUID playerId = event.getPlayerId();
            if (playerId != null && spell != null) {
                this.playersCastSpell.putIfAbsent(spell.getName(), new HashSet());
                this.playersCastSpell.get(spell.getName()).add(playerId);
            }
        }
    }

    public void reset() {
        this.playersCastSpell.clear();
    }

    public Set<UUID> getPlayersCastSpell(String spellName) {
        return this.playersCastSpell.getOrDefault(spellName, new HashSet());
    }
}

