/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class GrimaSarumansFootmanEffect
extends OneShotEffect {
    GrimaSarumansFootmanEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "that player exiles cards from the top of their library until they exile an instant or sorcery card. You may cast that card without paying its mana cost. Then that player puts the exiled cards that weren't cast this way on the bottom of their library in a random order.";
    }

    private GrimaSarumansFootmanEffect(GrimaSarumansFootmanEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrimaSarumansFootmanEffect copy() {
        return new GrimaSarumansFootmanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            player.moveCards(card, Zone.EXILED, source, game);
            if (!card.isInstantOrSorcery(game)) continue;
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
            break;
        }
        cards.retainZone(Zone.EXILED, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

