/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GrindclockEffect
extends OneShotEffect {
    GrindclockEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player mills X cards, where X is the number of charge counters on {this}";
    }

    private GrindclockEffect(GrindclockEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null) {
            int amount = sourceObject.getCounters(game).getCount(CounterType.CHARGE);
            Player targetPlayer = game.getPlayer(source.getFirstTarget());
            if (targetPlayer != null) {
                targetPlayer.millCards(amount, source, game);
                return true;
            }
        }
        return false;
    }

    public GrindclockEffect copy() {
        return new GrindclockEffect(this);
    }
}

