/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GrinningTotemDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class GrinningTotemSearchAndExileEffect
extends OneShotEffect {
    GrinningTotemSearchAndExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search target opponent's library for a card and exile it. Then that player shuffles. Until the beginning of your next upkeep, you may play that card. At the beginning of your next upkeep, if you haven't played it, put it into its owner's graveyard";
    }

    private GrinningTotemSearchAndExileEffect(GrinningTotemSearchAndExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrinningTotemSearchAndExileEffect copy() {
        return new GrinningTotemSearchAndExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        if (you == null || targetOpponent == null) {
            return false;
        }
        TargetCardInLibrary targetCard = new TargetCardInLibrary();
        you.searchLibrary(targetCard, source, game, targetOpponent.getId());
        Card card = targetOpponent.getLibrary().getCard(targetCard.getFirstTarget(), game);
        if (card != null) {
            UUID exileZoneId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            you.moveCardsToExile(card, source, game, true, exileZoneId, CardUtil.getSourceName((Game)game, (Ability)source));
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilYourNextUpkeepStep, (boolean)false);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new GrinningTotemDelayedTriggeredAbility(exileZoneId), source);
        }
        targetOpponent.shuffleLibrary(source, game);
        return true;
    }
}

