/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.target.Target;
import mage.util.RandomUtil;

class GripOfChaosEffect
extends OneShotEffect {
    GripOfChaosEffect() {
        super(Outcome.Neutral);
        this.staticText = "reselect its target at random";
    }

    private GripOfChaosEffect(GripOfChaosEffect effect) {
        super((OneShotEffect)effect);
    }

    public GripOfChaosEffect copy() {
        return new GripOfChaosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject == null) {
            return false;
        }
        Modes modes = stackObject.getStackAbility().getModes();
        for (Target target : modes.getSelectedModes().stream().map(arg_0 -> ((Modes)modes).get(arg_0)).map(Mode::getTargets).flatMap(Collection::stream).collect(Collectors.toList())) {
            UUID oldTargetId = target.getFirstTarget();
            Set possibleTargets = target.possibleTargets(stackObject.getControllerId(), stackObject.getStackAbility(), game);
            if (possibleTargets.contains(stackObject.getId())) {
                possibleTargets.remove(stackObject.getId());
            }
            if (possibleTargets.isEmpty()) continue;
            UUID newTargetId = (UUID)RandomUtil.randomFromCollection((Collection)possibleTargets);
            target.remove(oldTargetId);
            target.add(newTargetId, game);
        }
        return true;
    }
}

