/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GripOfChaosEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.SpellStack;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GripOfChaosTriggeredAbility
extends TriggeredAbilityImpl {
    GripOfChaosTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GripOfChaosEffect());
    }

    private GripOfChaosTriggeredAbility(GripOfChaosTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.TRIGGERED_ABILITY || event.getType() == GameEvent.EventType.COPIED_STACKOBJECT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        StackObject stackObject = this.getEffects().stream().findFirst().filter(Objects::nonNull).map(Effect::getTargetPointer).map(tp -> tp.getFirst(game, (Ability)this)).map(arg_0 -> ((SpellStack)game.getStack()).getStackObject(arg_0)).orElse(null);
        if (stackObject == null) {
            return false;
        }
        Modes modes = stackObject.getStackAbility().getModes();
        return modes.getSelectedModes().stream().map(arg_0 -> ((Modes)modes).get(arg_0)).map(Mode::getTargets).mapToInt(ArrayList::size).sum() == 1;
    }

    public String getRule() {
        return "Whenever a spell or ability is put onto the stack, if it has a single target, reselect its target at random.";
    }

    public GripOfChaosTriggeredAbility copy() {
        return new GripOfChaosTriggeredAbility(this);
    }
}

