/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class GrislySigilWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    GrislySigilWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && !((DamagedEvent)event).isCombatDamage()) {
            this.morSet.add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.morSet.clear();
    }

    static boolean checkPermanent(Permanent permanent, Game game) {
        return ((GrislySigilWatcher)game.getState().getWatcher(GrislySigilWatcher.class)).morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)permanent, game));
    }
}

