/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;

class GristTheHungerTideTypeEffect
extends ContinuousEffectImpl {
    GristTheHungerTideTypeEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "as long as {this} isn't on the battlefield, it's a 1/1 Insect creature in addition to its other types";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private GristTheHungerTideTypeEffect(GristTheHungerTideTypeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GristTheHungerTideTypeEffect copy() {
        return new GristTheHungerTideTypeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (game.getState().getZone(source.getSourceId()) == Zone.BATTLEFIELD) {
            return false;
        }
        Card sourceObject = game.getCard(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                sourceObject.addCardType(game, new CardType[]{CardType.CREATURE});
                sourceObject.addSubType(game, new SubType[]{SubType.INSECT});
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                sourceObject.getPower().setModifiedBaseValue(1);
                sourceObject.getToughness().setModifiedBaseValue(1);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }
}

