/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class GrolnokTheOmnivorePlayEffect
extends AsThoughEffectImpl {
    GrolnokTheOmnivorePlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may play lands and cast spells from among cards you own in exile with croak counters on them";
    }

    private GrolnokTheOmnivorePlayEffect(GrolnokTheOmnivorePlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public GrolnokTheOmnivorePlayEffect copy() {
        return new GrolnokTheOmnivorePlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        if (affectedControllerId.equals(source.getControllerId()) && (card = game.getCard(objectId)) != null) {
            Card mainCard = card.getMainCard();
            return game.getState().getZone(mainCard.getId()).equals((Object)Zone.EXILED) && mainCard.isOwnedBy(source.getControllerId()) && mainCard.getCounters(game).containsKey(CounterType.CROAK);
        }
        return false;
    }
}

