/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class GrothamaAllDevouringWatcher
extends Watcher {
    private Map<MageObjectReference, Map<UUID, Integer>> damageMap = new HashMap<MageObjectReference, Map<UUID, Integer>>();

    GrothamaAllDevouringWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        UUID damageControllerId = game.getControllerId(event.getSourceId());
        Permanent damaged = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (damaged == null || !damaged.isCreature(game) || damageControllerId == null) {
            return;
        }
        MageObjectReference mor = new MageObjectReference((MageObject)damaged, game);
        this.damageMap.putIfAbsent(mor, new HashMap());
        this.damageMap.get(mor).putIfAbsent(damageControllerId, 0);
        this.damageMap.get(mor).compute(damageControllerId, (k, damage) -> damage + event.getAmount());
    }

    public void reset() {
        super.reset();
        this.damageMap.clear();
    }

    public Map<UUID, Integer> getDamageMap(MageObjectReference mor) {
        return this.damageMap.getOrDefault(mor, new HashMap());
    }
}

