/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class GrowthCycle
extends CardImpl {
    private static final FilterCard filter = new FilterCard("card named Growth Cycle");
    private static final DynamicValue xValue;
    private static final String rule;
    private static final Hint hint;

    public GrowthCycle(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{G}");
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(3, 3, Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(xValue, xValue, Duration.EndOfTurn).setText(rule));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addHint(hint);
    }

    private GrowthCycle(GrowthCycle card) {
        super((CardImpl)card);
    }

    public GrowthCycle copy() {
        return new GrowthCycle(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Growth Cycle"));
        xValue = new CardsInControllerGraveyardCount(filter, Integer.valueOf(2));
        rule = "it gets an additional +2/+2 until end of turn for each " + xValue.getMessage();
        hint = new ValueHint("Cards named Growth Cycle in your graveyard", (DynamicValue)new CardsInControllerGraveyardCount(filter));
    }
}

