/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GruulRagebeastEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.common.TargetOpponentsCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.GameLog;

class GruulRagebeastTriggeredAbility
extends TriggeredAbilityImpl {
    GruulRagebeastTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GruulRagebeastEffect(), false);
        this.addTarget(new TargetOpponentsCreaturePermanent().withChooseHint("for fighting"));
    }

    private GruulRagebeastTriggeredAbility(GruulRagebeastTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GruulRagebeastTriggeredAbility copy() {
        return new GruulRagebeastTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId = event.getTargetId();
        Permanent permanent = game.getPermanent(targetId);
        Permanent sourceObject = game.getPermanent(this.getSourceId());
        if (sourceObject != null && permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game)) {
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof GruulRagebeastEffect)) continue;
                effect.setTargetPointer(new FixedTarget(event.getTargetId(), game).withData("triggeredName", GameLog.getColoredObjectIdNameForTooltip((MageObject)sourceObject)));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        String triggeredInfo = "";
        String triggeredMana = ((Effect)this.getEffects().get(0)).getTargetPointer().getData("triggeredName");
        if (!triggeredMana.isEmpty()) {
            triggeredInfo = " Your fighting creature: " + triggeredMana + ".";
        }
        return "Whenever {this} or another creature you control enters, that creature fights target creature an opponent controls." + triggeredInfo;
    }
}

