/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GryffsBoonEffect
extends OneShotEffect {
    GryffsBoonEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return this card from your graveyard to the battlefield attached to target creature";
    }

    private GryffsBoonEffect(GryffsBoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent;
        Card aura = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (aura != null && controller != null && game.getState().getZone(aura.getId()) == Zone.GRAVEYARD && !(targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))).cantBeAttachedBy((MageObject)aura, source, game, false)) {
            game.getState().setValue("attachTo:" + aura.getId(), (Object)targetPermanent);
            controller.moveCards(aura, Zone.BATTLEFIELD, source, game);
            return targetPermanent.addAttachment(aura.getId(), source, game);
        }
        return false;
    }

    public GryffsBoonEffect copy() {
        return new GryffsBoonEffect(this);
    }
}

