/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.SpecialAction;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.CreateSpecialActionEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.cards.g.GuardianAngelAction;
import mage.cards.g.GuardianAngelDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class GuardianAngelEffect
extends OneShotEffect {
    GuardianAngelEffect() {
        super(Outcome.Benefit);
        this.staticText = "Prevent the next X damage that would be dealt to any target this turn. Until end of turn, you may pay {1} any time you could cast an instant. If you do, prevent the next 1 damage that would be dealt to that permanent or player this turn";
    }

    private GuardianAngelEffect(GuardianAngelEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuardianAngelEffect copy() {
        return new GuardianAngelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            String targetName = "";
            Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (targetPlayer == null) {
                Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetPermanent == null) {
                    return true;
                }
                targetName = targetPermanent.getIdName();
            } else {
                targetName = "player " + targetPlayer.getName();
            }
            PreventDamageToTargetEffect effect = new PreventDamageToTargetEffect(Duration.EndOfTurn, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), false);
            effect.setTargetPointer(this.getTargetPointer().copy());
            game.addEffect((ContinuousEffect)effect, source);
            GuardianAngelAction specialAction = new GuardianAngelAction();
            ((Effect)specialAction.getEffects().get(0)).setTargetPointer(this.getTargetPointer().copy());
            ((Effect)specialAction.getEffects().get(0)).setText("Prevent the next 1 damage that would be dealt to any target this turn (" + targetName + ").");
            new CreateSpecialActionEffect((SpecialAction)specialAction).apply(game, source);
            new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new GuardianAngelDelayedTriggeredAbility(specialAction.getId()), false).apply(game, source);
            return true;
        }
        return false;
    }
}

