/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseSecretOpponentEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class GuardianArchonEffect
extends OneShotEffect {
    GuardianArchonEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and target permanent you control each gain protection from the chosen player until end of turn. Activate only once";
    }

    private GuardianArchonEffect(GuardianArchonEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuardianArchonEffect copy() {
        return new GuardianArchonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(ChooseSecretOpponentEffect.getChosenPlayer((Ability)source, (Game)game));
        if (player == null) {
            return false;
        }
        FilterPlayer filter = new FilterPlayer(player.getName());
        filter.add((Predicate)new PlayerIdPredicate(player.getId()));
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)new ProtectionAbility((Filter)filter), Duration.EndOfTurn), source);
        game.addEffect((ContinuousEffect)new GainAbilityControllerEffect((Ability)new ProtectionAbility((Filter)filter), Duration.EndOfTurn), source);
        return true;
    }
}

