/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class GuardianSeraphEffect
extends PreventionEffectImpl {
    GuardianSeraphEffect() {
        super(Duration.WhileOnBattlefield, 1, false, false);
        this.staticText = "If a source an opponent controls would deal damage to you, prevent 1 of that damage";
    }

    private GuardianSeraphEffect(GuardianSeraphEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID sourceControllerId;
        if (event.getTargetId().equals(source.getControllerId()) && (sourceControllerId = game.getControllerId(event.getSourceId())) != null && game.getOpponents(source.getControllerId()).contains(sourceControllerId)) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public GuardianSeraphEffect copy() {
        return new GuardianSeraphEffect(this);
    }
}

