/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateAsSorceryActivatedAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.SaddleTargetMountEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GuidelightMatrix
extends CardImpl {
    private static final FilterControlledPermanent mountFilter = new FilterControlledPermanent("Mount you control");
    private static final FilterControlledPermanent vehicleFilter = new FilterControlledPermanent("Vehicle you control");

    public GuidelightMatrix(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1)));
        ActivateAsSorceryActivatedAbility saddledAbility = new ActivateAsSorceryActivatedAbility((Effect)new SaddleTargetMountEffect(), (Cost)new ManaCostsImpl("{2}"));
        saddledAbility.addCost((Cost)new TapSourceCost());
        saddledAbility.addTarget((Target)new TargetPermanent((FilterPermanent)mountFilter));
        this.addAbility((Ability)saddledAbility);
        SimpleActivatedAbility animateVehicleAbility = new SimpleActivatedAbility((Effect)new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}).setText("Target Vehicle you control becomes an artifact creature until end of turn."), (Cost)new ManaCostsImpl("{2}"));
        animateVehicleAbility.addCost((Cost)new TapSourceCost());
        animateVehicleAbility.addTarget((Target)new TargetPermanent((FilterPermanent)vehicleFilter));
        this.addAbility((Ability)animateVehicleAbility);
    }

    private GuidelightMatrix(GuidelightMatrix card) {
        super((CardImpl)card);
    }

    public GuidelightMatrix copy() {
        return new GuidelightMatrix(this);
    }

    static {
        mountFilter.add((Predicate)SubType.MOUNT.getPredicate());
        vehicleFilter.add((Predicate)SubType.VEHICLE.getPredicate());
    }
}

