/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class GuildFeudEffect
extends OneShotEffect {
    GuildFeudEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "target opponent reveals the top three cards of their library, may put a creature card from among them onto the battlefield, then puts the rest into their graveyard. You do the same with the top three cards of your library. If two creatures are put onto the battlefield this way, those creatures fight each other";
    }

    private GuildFeudEffect(GuildFeudEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        Permanent opponentCreature = null;
        Permanent controllerCreature = null;
        MageObject sourceObject = source.getSourceObject(game);
        if (opponent != null && controller != null && sourceObject != null) {
            for (int activePlayer = 0; activePlayer < 2; ++activePlayer) {
                Card creatureToBattlefield;
                TargetCard target;
                Player player = activePlayer == 0 ? opponent : controller;
                CardsImpl topThreeCards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
                player.revealCards(source, player.getName() + " top library cards", (Cards)topThreeCards, game);
                if (topThreeCards.isEmpty()) continue;
                if (player.chooseUse(Outcome.PutCreatureInPlay, "Put a creature card among them to the battlefield?", source, game) && player.choose(Outcome.PutCreatureInPlay, (Cards)topThreeCards, target = new TargetCard(Zone.LIBRARY, (FilterCard)new FilterCreatureCard("creature card to put on the battlefield")), source, game) && (creatureToBattlefield = topThreeCards.get(target.getFirstTarget(), game)) != null) {
                    topThreeCards.remove(creatureToBattlefield);
                    if (player.moveCards(creatureToBattlefield, Zone.BATTLEFIELD, source, game)) {
                        if (activePlayer == 0) {
                            opponentCreature = game.getPermanent(creatureToBattlefield.getId());
                        } else {
                            controllerCreature = game.getPermanent(creatureToBattlefield.getId());
                        }
                    }
                }
                player.moveCards((Cards)topThreeCards, Zone.GRAVEYARD, source, game);
            }
            if (opponentCreature != null && controllerCreature != null) {
                opponentCreature.fight(controllerCreature, source, game);
            }
            return true;
        }
        return false;
    }

    public GuildFeudEffect copy() {
        return new GuildFeudEffect(this);
    }
}

