/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GustOfWind
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent("you control a creature with flying");
    private static final FilterPermanent filter2 = new FilterNonlandPermanent("nonland permanent you don't control");
    private static final Condition condition;

    public GustOfWind(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{U}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2, condition)).setRuleAtTheTop(true).addHint((Hint)new ConditionHint(condition, "You control a creature with flying")));
        this.getSpellAbility().addEffect((Effect)new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter2));
        this.getSpellAbility().addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy("<br>"));
    }

    private GustOfWind(GustOfWind card) {
        super((CardImpl)card);
    }

    public GustOfWind copy() {
        return new GustOfWind(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        filter2.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        condition = new PermanentsOnTheBattlefieldCondition(filter);
    }
}

