/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class GyomeMasterChefWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    GyomeMasterChefWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent == null || permanent instanceof PermanentToken || !permanent.isCreature(game)) {
            return;
        }
        this.playerMap.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    static int getValue(UUID playerId, Game game) {
        GyomeMasterChefWatcher watcher = (GyomeMasterChefWatcher)game.getState().getWatcher(GyomeMasterChefWatcher.class);
        if (watcher == null) {
            return 0;
        }
        return watcher != null ? watcher.playerMap.getOrDefault(playerId, 0) : 0;
    }
}

