/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GyrusWakerOfCorpsesEffect
extends OneShotEffect {
    GyrusWakerOfCorpsesEffect() {
        super(Outcome.Copy);
        this.staticText = "exile target creature card with lesser power from your graveyard. If you do, create a token that's a copy of that card and that's tapped and attacking. Exile the token at the end of combat.";
    }

    private GyrusWakerOfCorpsesEffect(GyrusWakerOfCorpsesEffect effect) {
        super((OneShotEffect)effect);
    }

    public GyrusWakerOfCorpsesEffect copy() {
        return new GyrusWakerOfCorpsesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true, 1, true, true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        effect.apply(game, source);
        for (Permanent addedToken : effect.getAddedPermanents()) {
            ExileTargetEffect exileEffect = new ExileTargetEffect();
            exileEffect.setTargetPointer((TargetPointer)new FixedTarget(addedToken, game));
            new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)exileEffect), false).apply(game, source);
        }
        return true;
    }
}

