/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TakeEffect
extends OneShotEffect {
    TakeEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Remove all +1/+1 counters from target creature you control. Draw that many cards";
    }

    private TakeEffect(TakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TakeEffect copy() {
        return new TakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        int countersRemoved = creature.removeAllCounters(CounterType.P1P1.getName(), source, game);
        if (countersRemoved > 0) {
            controller.drawCards(countersRemoved, source, game);
        }
        return true;
    }
}

