/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

enum HagraMaulingCondition implements Condition
{
    instance;

    private static final FilterPermanent filter;

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null || game.getBattlefield().count(filter, playerId, source, game) != 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "an opponent controls no basic lands";
    }

    static {
        filter = new FilterControlledLandPermanent();
        filter.add((Predicate)SuperType.BASIC.getPredicate());
    }
}

