/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class HaktosTheUnscarredChooseEffect
extends OneShotEffect {
    HaktosTheUnscarredChooseEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose 2, 3, or 4 at random";
    }

    private HaktosTheUnscarredChooseEffect(HaktosTheUnscarredChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaktosTheUnscarredChooseEffect copy() {
        return new HaktosTheUnscarredChooseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent == null) {
            permanent = game.getPermanent(source.getSourceId());
        }
        if (controller == null || permanent == null) {
            return false;
        }
        int number = 2 + RandomUtil.nextInt((int)3);
        game.informPlayers(permanent.getLogName() + ": " + controller.getLogName() + " has chosen " + number + " at random");
        game.getState().setValue(permanent.getId() + "" + source.getStackMomentSourceZCC() + "_haktos_number", (Object)number);
        permanent.addInfo("chosen number", CardUtil.addToolTipMarkTags((String)("Chosen number: " + number)), game);
        return true;
    }
}

