/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class HallOfGemstoneEffect
extends ReplacementEffectImpl {
    HallOfGemstoneEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "that player chooses a color. Until end of turn, lands tapped for mana produce mana of the chosen color instead of any other color";
    }

    private HallOfGemstoneEffect(HallOfGemstoneEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public HallOfGemstoneEffect copy() {
        return new HallOfGemstoneEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent mageObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player == null || mageObject == null) {
            return;
        }
        ChoiceColor choice = new ChoiceColor();
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            this.discard();
            return;
        }
        game.informPlayers(mageObject.getLogName() + ": " + player.getLogName() + " has chosen " + choice.getChoice());
        game.getState().setValue(mageObject.getId() + "_color", (Object)choice.getColor());
        mageObject.addInfo("chosen color", CardUtil.addToolTipMarkTags((String)("Chosen color: " + choice.getChoice())), game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ObjectColor colorChosen = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        if (colorChosen == null) {
            return false;
        }
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        int genericAmount = mana.getGeneric();
        int colorlessAmount = mana.getColorless();
        int coloredAmount = mana.countColored();
        switch (colorChosen.getOneColoredManaSymbol()) {
            case W: {
                mana.setToMana(Mana.WhiteMana((int)coloredAmount));
                break;
            }
            case U: {
                mana.setToMana(Mana.BlueMana((int)coloredAmount));
                break;
            }
            case B: {
                mana.setToMana(Mana.BlackMana((int)coloredAmount));
                break;
            }
            case R: {
                mana.setToMana(Mana.RedMana((int)coloredAmount));
                break;
            }
            case G: {
                mana.setToMana(Mana.GreenMana((int)coloredAmount));
            }
        }
        mana.setGeneric(genericAmount);
        mana.setColorless(colorlessAmount);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game);
    }
}

