/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HallOfTriumphBoostControlledEffect
extends ContinuousEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public HallOfTriumphBoostControlledEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Creatures you control of the chosen color get +1/+1";
    }

    private HallOfTriumphBoostControlledEffect(HallOfTriumphBoostControlledEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HallOfTriumphBoostControlledEffect copy() {
        return new HallOfTriumphBoostControlledEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ObjectColor color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        if (color != null) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                if (!perm.getColor(game).shares(color)) continue;
                perm.addPower(1);
                perm.addToughness(1);
            }
            return true;
        }
        return false;
    }
}

