/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.common.PermanentWasCastWatcher;

class HallowedMoonlightEffect
extends ReplacementEffectImpl {
    HallowedMoonlightEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "Until end of turn, if a creature would enter and it wasn't cast, exile it instead";
    }

    private HallowedMoonlightEffect(HallowedMoonlightEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public HallowedMoonlightEffect copy() {
        return new HallowedMoonlightEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(event.getTargetId());
        if (targetCard == null) {
            targetCard = ((EntersTheBattlefieldEvent)event).getTarget();
        }
        if (controller != null && targetCard != null) {
            controller.moveCards(targetCard, Zone.EXILED, source, game, false, false, false, null);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        PermanentWasCastWatcher watcher;
        EntersTheBattlefieldEvent entersTheBattlefieldEvent = (EntersTheBattlefieldEvent)event;
        return entersTheBattlefieldEvent.getTarget().isCreature(game) && (watcher = (PermanentWasCastWatcher)game.getState().getWatcher(PermanentWasCastWatcher.class)) != null && !watcher.wasPermanentCastThisTurn(event.getTargetId());
    }
}

