/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.h.HamletbackGoliathEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HamletbackGoliathTriggeredAbility
extends TriggeredAbilityImpl {
    HamletbackGoliathTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new HamletbackGoliathEffect(), true);
    }

    private HamletbackGoliathTriggeredAbility(HamletbackGoliathTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HamletbackGoliathTriggeredAbility copy() {
        return new HamletbackGoliathTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId = event.getTargetId();
        Permanent permanent = game.getPermanent(targetId);
        if (permanent != null && permanent.isCreature(game) && !targetId.equals(this.getSourceId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever another creature enters the battlefield, you may put X +1/+1 counters on {this}, where X is that creature's power.";
    }
}

