/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.h.HankyuCost;
import mage.cards.h.HankyuValue;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HankyuEffect
extends ContinuousEffectImpl {
    HankyuEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "equipped creature has \"{T}: Put an aim counter on {this}\" and \"{T}, Remove all aim counters from {this}: This creature deals damage to any target equal to the number of aim counters removed this way.\"";
    }

    private HankyuEffect(HankyuEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HankyuEffect copy() {
        return new HankyuEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        Permanent creature = game.getPermanent(permanent.getAttachedTo());
        if (creature == null) {
            return false;
        }
        creature.addAbility((Ability)new SimpleActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.AIM.createInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).setText("put an aim counter on " + permanent.getName()), (Cost)new TapSourceCost()), source.getSourceId(), game);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DamageTargetEffect((DynamicValue)HankyuValue.instance).setText("this creature deals damage to any target equal to the number of aim counters removed this way"), (Cost)new TapSourceCost());
        ability.addCost((Cost)new HankyuCost().setMageObjectReference(source, game));
        ability.addTarget((Target)new TargetAnyTarget());
        creature.addAbility((Ability)ability, source.getSourceId(), game);
        return true;
    }
}

